// This scilab code is to calculate basic image statistics
//such as sum, average, standard deviation, min and max

//The scilab environment for this is : Scilab 5.5.2

//Toolbox used: SIVP 0.5.3.2

//OS used : Windows 10 64 bit
// 
//Reference book name : Digital Image Processing
//book author: Rafael C. Gonzalez and Richard E. Woods

clc //to clear command window.
clear all //to kill previously defined variables.
xdel(winsid())//to close all currently open figure(s).

//This code uses camaraman.tif file for processing
//SCI + '/contrib/SIVP_0.5.3.2/images/lena.png'
img = imread('cameraman.png');  // Reads the cameraman image
//title("Original Image");
imshow(img);                    // Show original image.
if(size(img,3)>1) then 
    Gray_img= rgb2gray(img);    //Converts color image to grayscale
else 
    Gray_img=img;               // if image is 2D image
end


filter = fspecial('sobel');     // Creates 2D special filter 'sobel'
imf = imfilter(Gray_img, filter); // Apply filter on 2D image
//pause;
//title("Filtered Image");
figure, imshow(imf);                    // Show Resultant Image
